/*****************************************************************************
 Copyright(c) 2009 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification of New, Modify, Append, Delete
 v	  v 	v
 No  Ver  Class Date				Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New 2012/10/01		New
 001 02.12 MOD  2014/12/12      Fixed #13672
*****************************************************************************/

/* Include specification *********************************************************/
#include "SMTAPI.h"

#define OK				0
#define ERR_NO_CITY		1
#define ERR_NO_NAME		2
#define LEVEL_DEBUG		0
#define LEVEL_LOG		5
#define TOKYO			0
#define NEWYORK			1
#define NULL			((void*)0)

static const char* name_table[]={
	"Taro", "Hurry", "Sally"
};

/* Function prototypes ******************************************************/
int main(void);
int hello_world(unsigned long city, unsigned long person);
int hello_from_tokyo(unsigned long person);
int hello_from_newyork(unsigned long person);
char* get_name(unsigned long person);

/*****************************************************************************
1.Function: main 

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------

4.Return Value:

*****************************************************************************/
int main(void)
{
	int status;
	unsigned long i = 0;

	_SMT_PUTS(LEVEL_DEBUG, "main() called");

	while(1) {
		_SMT_PRINTF(LEVEL_DEBUG, "i = %d", i);
		status = hello_world(i%4, i%5);
		if (status != OK) {
			_SMT_PRINTF(LEVEL_DEBUG, "hello_world() returns %d", status);
		}
		i++;
	}
	return 0;
}

int hello_world(unsigned long city,unsigned long person)
{
	int status;

	_SMT_PUTS(LEVEL_DEBUG, "hello_world() called");
	_SMT_PUTS(LEVEL_LOG, "Hello, world!");

	switch(city) {
	case TOKYO:
		status = hello_from_tokyo(person);
		if (status != OK) {
			_SMT_PRINTF(LEVEL_DEBUG, "hello_from_tokyo() returns %d", status);
		}
		break;
	case NEWYORK:
		status = hello_from_newyork(person);
		if (status != OK) {
			_SMT_PRINTF(LEVEL_DEBUG, "hello_from_newyork() returns %d", status);
		}
		break;
	default:
		_SMT_PRINTF(LEVEL_DEBUG, "No such city %d", city);
		return (ERR_NO_CITY);
	}

	return(status);
}

int hello_from_tokyo(unsigned long person)
{
	char* name;

	_SMT_PUTS(LEVEL_DEBUG, "hello_from_tokyo() called");
	name = get_name(person);
	if ( name == NULL ) {
		return (ERR_NO_NAME);
	}
	_SMT_PRINTF(LEVEL_LOG, "This is %s. Hello from Tokyo!", name);

	return(OK);
}

int hello_from_newyork(unsigned long person)
{
	char* name;

	_SMT_PUTS(LEVEL_DEBUG, "hello_from_newyork() called");
	name = get_name(person);
	if ( name == NULL ) {
		return (ERR_NO_NAME);
	}
	_SMT_PRINTF(LEVEL_LOG, "This is %s. Hello from New York!", name);

	return(OK);
}

char* get_name(unsigned long person)
{
	_SMT_PUTS(LEVEL_DEBUG, "get_name() called");
	if (person >= (sizeof(name_table)/sizeof(char*))) {
		_SMT_PRINTF(LEVEL_DEBUG, "No such person %d", person);
		return(NULL);
	}
	return((char*)name_table[person]);
}

