#!/bin/bash
#
# @(#) install Linux Apilibrary.sh ver.0.0.1 2013.01.16
#
# Description:
#   SMT Open API Library Copy Script
#
###########################################################################
# SMT API Library Copy Script for Linux

#SMT output I/F [appSD/ExternalBus/GPIO/SD/SoftwareModel/USBdevice]
SMT_INTERFACE=appSD
#SMT API Library top directory full path
SMT_API_LIBRARY_DIR=/home/<user env>/APILib_Linux_xxx

#kernel source directory full path
KERNEL_DIR=/home/<user env>/<kernel>

#SMT_INTERFACE Input check
if [ "${SMT_INTERFACE}" = "" ]
then
	echo "Please Input SMT_Interface[appSD/ExternalBus/GPIO/SD/SoftwareModel/USBdevice]"
	read Interface
	if [ "${Interface}" = "SD" ] || [ "${Interface}" = "ExternalBus" ] || [ "${Interface}" = "GPIO" ] || [ "${Interface}" = "USBdevice" ] || [ "${Interface}" = "appSD" ] || [ "${Interface}" = "SoftwareModel" ] ;
	then
		SMT_INTERFACE=${Interface}
	else
		echo "Invalid Interface"
		exit
	fi
fi

#SMT_API_LIBRARY_DIR input check
if [ "${SMT_API_LIBRARY_DIR}" = "" ]
then
	echo "Please Input SMT_API_LIBRARY_DIR"
	read libraryDir
	if [ -e ${libraryDir} ] ;
	then
		if [ -d ${libraryDir} ] ;
		then
			SMT_API_LIBRARY_DIR=${libraryDir}
		else
			echo "${libraryDir} is not directory"
			exit
		fi
	else
		echo "No such directory"
		exit
	fi
fi

#KERNEL_DIR input check
if [ "${KERNEL_DIR}" = "" ]
then
	echo "Please Input KERNEL_DIR"
	read kernelDir
	if [ -e ${kernelDir} ] ;
	then
		if [ -d ${kernelDir} ] ;
		then
			KERNEL_DIR=${kernelDir}
		else
			echo "${kernelDir} is not directory"
			exit
		fi
	else
		echo "No such directory"
		exit
	fi
fi



echo ""
echo "Config Info"
echo " SMT_INTERFACE       : ${SMT_INTERFACE}"
echo " SMT_API_LIBRARY_DIR : ${SMT_API_LIBRARY_DIR}"
echo " KERNEL_DIR          : ${KERNEL_DIR}"
echo ""

echo "Do you want to copy Kernel Land API Library?[y/n]"
read kernelLandAPIcopyFlag

if [ "${kernelLandAPIcopyFlag}" = "y" ]
	then
	cp -a ${SMT_API_LIBRARY_DIR}/${SMT_INTERFACE}/kernel/* ${KERNEL_DIR}/
	echo "Linux Kernel Land API Library Copy Done"
	echo ""
fi



echo "Please Modify sources"
if [ "${kernelLandAPIcopyFlag}" = "y" ]
	then
	echo " ${KERNEL_DIR}/Makefile"
	if [ "${SMT_INTERFACE}" = "appSD" ]
		then
		echo " ${KERNEL_DIR}/Kconfig"
		echo " ${KERNEL_DIR}/drivers/mmc/core/sd.c"
	fi
fi
