/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01      New
 001 02.12 MOD  2014/12/12      Fixed #13672
                                #13699

*****************************************************************************/
#define __TRQPORTOUT_C__

/* Include specification ****************************************************/
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include "SMTDef.h"
#include "SMTAPI.h"
#include "smtif.h"

/* External variables *******************************************************/
extern int smt_fd;

#define	_SMT_PORTOUT_DATA_SIZE				3				// PortOut output data size (unsigned long)

/*****************************************************************************
1.Function: Output Address,Data,Size,Read/Write info

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	addr						Address value
I/	data						Data value
I/	size						Port size 1:8bit 2:16bit 3:32bit
I/	rw							Access type 0:Write 1:Read

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_PortOut(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw)
{
	int status;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_PORTOUT_DATA_SIZE] __attribute__ ((aligned(4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return( _SMT_NG );
	}

	out[0] = _SMT_ATR_PORTOUT | _SMT_OUT_SIZE_PORTOUT | ((rw & _SMT_MASK_PORTOUT_RW) << _SMT_PORTOUT_RW_POS) | (size & _SMT_MASK_PORTOUT_SIZE);
	out[1] = addr;
	out[2] = data;
	status = write(smt_fd, out, _SMT_PORTOUT_DATA_SIZE);
	if( status<0 ){
		return( _SMT_NG );
	}
	return( _SMT_OK );
}
