/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification of New, Modify, Append, Delete
 v	  v 	v
 No  Ver  Class Date				Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New	2012/10/01		New
 001 02.00 Mod	2014/01/06		Fixed #13339
 002 02.12 MOD  2014/12/12      Fixed #13672
                                #13699

*****************************************************************************/
#ifndef __SMTDEF_H__
#define __SMTDEF_H__

#define	_SMT_ATR_POS			28							/* Attribute postion 					*/
#define	_SMT_OUT_SIZE_POS		21							/* Output Size positon 					*/
#define	_SMT_OS_SWITCH_TYPE_POS	17							/* OS switch position 					*/
#define	_SMT_OS_CALL_ATTR_POS	16							/* OS call type position 				*/
                                                            
/* API Header Atrribute */
#define	_SMT_ATR_PORTOUT		(0x2UL << _SMT_ATR_POS)		/* PORT OUT */
#define	_SMT_ATR_PRINT			(0x5UL << _SMT_ATR_POS)		/* Print Message  */
#define	_SMT_ATR_OS_SWITCH		(0x7UL << _SMT_ATR_POS)		/* OS Switch							*/
#define	_SMT_ATR_OS_CALL		(0x9UL << _SMT_ATR_POS)		/* OS Call								*/
#define	_SMT_ATR_MPU			(0xbUL << _SMT_ATR_POS)		/* MPU type								*/
#define	_SMT_ATR_FUNC_NA		(0xAUL << _SMT_ATR_POS)		/* Function Trace (argument 2~16) ATTR A*/
#define	_SMT_ATR_FUNC_NF		(0xFUL << _SMT_ATR_POS)		/* Function Trace (argument 2~16) ATTR F*/
#define	_SMT_ATR_FUNC			(0xCUL << _SMT_ATR_POS)		/* Function Trace (argument 2~16) 		*/
#define	_SMT_ATR_FUNC_0			(0xDUL << _SMT_ATR_POS)		/* Function Trace (argument 0)	unused	*/
#define	_SMT_ATR_FUNC_1			(0xEUL << _SMT_ATR_POS)		/* Function Trace (argument 1)	unused	*/

/* Hook Output Size */
#define	_SMT_OUT_SIZE_HOOK_2	(3UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_3	(4UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_4	(5UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_5	(6UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_6	(7UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_7	(8UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_8	(9UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_9	(10UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_10	(11UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_11	(12UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_12	(13UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_13	(14UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_14	(15UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_15	(16UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_HOOK_16	(17UL << _SMT_OUT_SIZE_POS)

/* PORTOUT */
#define	_SMT_OUT_SIZE_PORTOUT		(2UL << _SMT_OUT_SIZE_POS)	/* PORT OUT 8,16,32bit */
#define	_SMT_OUT_SIZE_PORTOUT64		(3UL << _SMT_OUT_SIZE_POS)	/* PORT OUT 64bit */
#define	_SMT_MASK_PORTOUT_SIZE		0x00000003UL
#define	_SMT_MASK_PORTOUT_RW		0x00000001UL
#define	_SMT_PORTOUT_SIZE_POS		0
#define	_SMT_PORTOUT_RW_POS			2

/* Debug Print */
#define	_SMT_STR_MAX_SIZE_B		124
#define	_SMT_DBG_LV_POS			16
#define	_SMT_DBG_LV_MSK			0x0000000F
#define _SMT_PUTW_BUF_SIZE_B	(_SMT_STR_MAX_SIZE_B + 4)

/* User Message Tag */
#define	_SMT_MSG_TAG_ON	0x00100000UL
#define	_SMT_OUT_SIZE_USRMSGTAG_0	(0UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_USRMSGTAG_1	(1UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_USRMSGTAG_2	(2UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_USRMSGTAG_3	(3UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OUT_SIZE_USRMSGTAG_4	(4UL << _SMT_OUT_SIZE_POS)
#define	_SMT_MASK_MSGNO	0x0000FFFFUL

/* OS Switch */
#define	_SMT_OS_SWITCH_PROCESS				(0UL << _SMT_OS_SWITCH_TYPE_POS)
#define	_SMT_OS_SWITCH_THREAD				(1UL << _SMT_OS_SWITCH_TYPE_POS)
#define	_SMT_OS_SWITCH_PROCESS_NAME			(2UL << _SMT_OS_SWITCH_TYPE_POS)
#define	_SMT_OS_SWITCH_THREAD_NAME			(3UL << _SMT_OS_SWITCH_TYPE_POS)
#define	_SMT_OS_SWITCH_IRQ_IN				(4UL << _SMT_OS_SWITCH_TYPE_POS)
#define	_SMT_OS_SWITCH_IRQ_OUT				(5UL << _SMT_OS_SWITCH_TYPE_POS)
#define	_SMT_OS_SWITCH_IDLE					(6UL << _SMT_OS_SWITCH_TYPE_POS)

#define	_SMT_OS_SWITCH_SIZE_PROCESS			(1UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_SWITCH_SIZE_THREAD			(2UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_SWITCH_SIZE_IRQ_IN			(1UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_SWITCH_SIZE_IRQ_OUT			(1UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_SWITCH_NAME_MAX				56									// Process/Thread name max string length



/* OS Call */
#define	_SMT_OS_CALL_MASK_OSC				0x0000FFFFUL
#define	_SMT_OS_CALL_MASK_ATTR				0x00000001UL
#define	_SMT_OS_CALL_SIZE_1					(1UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_2					(2UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_3					(3UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_4					(4UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_5					(5UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_6					(6UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_7					(7UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_8					(8UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_9					(9UL  << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_10				(10UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_11				(11UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_12				(12UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_13				(13UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_14				(14UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_15				(15UL << _SMT_OUT_SIZE_POS)
#define	_SMT_OS_CALL_SIZE_16				(16UL << _SMT_OUT_SIZE_POS)


/* MPU type certification */
#define	_SMT_MPU_SIZE						(3UL << _SMT_OUT_SIZE_POS)
#define	_SMT_MPU_BIG_ENDIAN					0x00000001UL
#define	_SMT_MPU_LTL_ENDIAN					0x00000000UL

#endif // __SMTDEF_H__