/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01   New
 001 02.12 Mod  2015/02/16   #13699
 002 03.10 Mod  2016/05/20   SMTNEW-288

*****************************************************************************/
#ifndef __SMTAPI_H__
#define __SMTAPI_H__

#define _SMT_OFF 0
#define _SMT_ON 	1

typedef unsigned int _SMT_UNSIGNED_32BIT_INTEGER;

#define _SMT_OUTPUT_SP_ADDR	_SMT_OFF

#define	_SMT_OK			0			// normal end
#define	_SMT_NG			-1			// abnoarmal end

#if !defined(_SMT_PORT_DIS) && !defined(_SMT_ALL_DIS)
	#define	_SMT_PORTOUT		_SMT_PortOut
#else	// _SMT_PORT_DIS
	#define	_SMT_PORTOUT		1 ? (void)0 : _SMT_PortOut
#endif	// _SMT_PORT_DIS

typedef enum {
	_SMT_PSZ64 = 0,
	_SMT_PSZ8,
	_SMT_PSZ16,
	_SMT_PSZ32
} _SMT_PSZ ;

typedef enum{
	_SMT_PW = 0,
	_SMT_PR
} _SMT_PRW;

#if !defined(_SMT_PRINT_DIS) && !defined(_SMT_ALL_DIS)
	#define	_SMT_PRINTF			_SMT_Printf
	#define	_SMT_PUTS			_SMT_Puts
	#define	_SMT_USRMSGTAG0		_SMT_UsrMsgTag0
	#define	_SMT_USRMSGTAG1		_SMT_UsrMsgTag1
	#define	_SMT_USRMSGTAG2		_SMT_UsrMsgTag2
	#define	_SMT_USRMSGTAG3		_SMT_UsrMsgTag3
	#define	_SMT_USRMSGTAG4		_SMT_UsrMsgTag4
#else	// _SMT_PRINT_DIS
	#define	_SMT_PRINTF			1 ? (void)0 : _SMT_Printf
	#define	_SMT_PUTS			1 ? (void)0 : _SMT_Puts
	#define	_SMT_USRMSGTAG0		1 ? (void)0 : _SMT_UsrMsgTag0
	#define	_SMT_USRMSGTAG1		1 ? (void)0 : _SMT_UsrMsgTag1
	#define	_SMT_USRMSGTAG2		1 ? (void)0 : _SMT_UsrMsgTag2
	#define	_SMT_USRMSGTAG3		1 ? (void)0 : _SMT_UsrMsgTag3
	#define	_SMT_USRMSGTAG4		1 ? (void)0 : _SMT_UsrMsgTag4
#endif	// _SMT_PRINT_DIS



#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus
	int _SMT_Init(void);
	int _SMT_Open(void);
	int _SMT_Close(void);
	int _SMT_PortOut(_SMT_UNSIGNED_32BIT_INTEGER addr ,_SMT_UNSIGNED_32BIT_INTEGER data ,_SMT_PSZ size ,_SMT_PRW rw );
	int _SMT_Printf(int level, const char *format , ...);
	int _SMT_Puts(int level, const char *s);
	int _SMT_UsrMsgTag0(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum);
	int _SMT_UsrMsgTag1(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
	int _SMT_UsrMsgTag2(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
	int _SMT_UsrMsgTag3(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
	int _SMT_UsrMsgTag4(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
	int  _SMT_GetDebugLevel(void);
	void _SMT_SetDebugLevel(int level);
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER _SMT_get_SP_address(void);
#endif

#ifdef __cplusplus
}
#endif // __cplusplus

#endif /* __SMTAPI_H__ */
