/*****************************************************************************
						Copyright(c) 2010 DTS INSIGHT CORPORATION
Function: SMT standard library header file

Note:

Change history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification :NEW, CHG(Change), ADD(Addition, DEL(Delete)
 v	  v 	v
 No  Ver  Class Date	  Name			Description
---+-----+----+----------+-------------+--------------------------------------
000 03.00 NEW  2015/03/16 ---			New
*****************************************************************************/


#include <smt/SMTAPI.h>
#include <smt/SMTAPI_CP.h>
#include <linux/module.h>


int  _SMT_CP_PortOut(_TRQ_PRT addr ,_TRQ_PRT data ,_SMT_CP_PSZ size ,_SMT_CP_PRW rw ){
	return _SMT_PortOut(addr , data , (_SMT_PSZ)size , (_SMT_PRW)rw);
}
EXPORT_SYMBOL(_SMT_CP_PortOut);

int  _SMT_CP_Puts(int level, const char *s){
	return _SMT_Puts(level, s);
}
EXPORT_SYMBOL(_SMT_CP_Puts);

int  _SMT_CP_UsrMsgTag0(int level,_TRQ_PRT TagNum){
	return _SMT_UsrMsgTag0(level, TagNum);
}
EXPORT_SYMBOL(_SMT_CP_UsrMsgTag0);

int  _SMT_CP_UsrMsgTag1(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1){
	return _SMT_UsrMsgTag1(level, TagNum, arg1);
}
EXPORT_SYMBOL(_SMT_CP_UsrMsgTag1);

int  _SMT_CP_UsrMsgTag2(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1,_TRQ_PRT arg2){
	return _SMT_UsrMsgTag2(level, TagNum, arg1, arg2);
}
EXPORT_SYMBOL(_SMT_CP_UsrMsgTag2);

int  _SMT_CP_UsrMsgTag3(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3){
	return _SMT_UsrMsgTag3(level, TagNum, arg1, arg2, arg3);
}
EXPORT_SYMBOL(_SMT_CP_UsrMsgTag3);

int  _SMT_CP_UsrMsgTag4(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4){
	return _SMT_UsrMsgTag4(level, TagNum, arg1, arg2, arg3, arg4);
}
EXPORT_SYMBOL(_SMT_CP_UsrMsgTag4);


int _SMT_CP_OsSwitch_Process(_TRQ_PRT processid){
	return _SMT_OsSwitch_Process(processid);
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_Process);

int _SMT_CP_OsSwitch_ThreadProcess(_TRQ_PRT threadid,_TRQ_PRT processid){
	return _SMT_OsSwitch_ThreadProcess(threadid, processid);
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_ThreadProcess);

int _SMT_CP_OsSwitch_Process_Name(_TRQ_PRT processid,const char *str){
	return _SMT_OsSwitch_Process_Name(processid, str);
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_Process_Name);

int _SMT_CP_OsSwitch_ThreadProcess_Name(_TRQ_PRT threadid,_TRQ_PRT processid,const char *tname,const char *pname){
	return _SMT_OsSwitch_ThreadProcess_Name(threadid, processid, tname, pname);
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_ThreadProcess_Name);

int _SMT_CP_OsSwitch_Irq_in(_TRQ_PRT irqid){
	return _SMT_OsSwitch_Irq_in(irqid);
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_Irq_in);

int _SMT_CP_OsSwitch_Irq_out(_TRQ_PRT irqid){
	return _SMT_OsSwitch_Irq_out(irqid);
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_Irq_out);

int _SMT_CP_OsSwitch_Idle( void ){
	return _SMT_OsSwitch_Idle();
}
EXPORT_SYMBOL(_SMT_CP_OsSwitch_Idle);

int _SMT_CP_OsCall0(int osc,_SMT_CP_OS_CALL attr){
	return _SMT_OsCall0(osc, (_SMT_OS_CALL)attr);
}
EXPORT_SYMBOL(_SMT_CP_OsCall0);

int _SMT_CP_OsCall1(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1){
	return _SMT_OsCall1(osc, (_SMT_OS_CALL)attr, arg1);
}
EXPORT_SYMBOL(_SMT_CP_OsCall1);

int _SMT_CP_OsCall2(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2){
	return _SMT_OsCall2(osc, (_SMT_OS_CALL)attr, arg1, arg2);
}
EXPORT_SYMBOL(_SMT_CP_OsCall2);

int _SMT_CP_OsCall3(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3){
	return _SMT_OsCall3(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3);
}
EXPORT_SYMBOL(_SMT_CP_OsCall3);

int _SMT_CP_OsCall4(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4){
	return _SMT_OsCall4(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4);
}
EXPORT_SYMBOL(_SMT_CP_OsCall4);

int _SMT_CP_OsCall5(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5){
	return _SMT_OsCall5(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5);
}
EXPORT_SYMBOL(_SMT_CP_OsCall5);

int _SMT_CP_OsCall6(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6){
	return _SMT_OsCall6(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6);
}
EXPORT_SYMBOL(_SMT_CP_OsCall6);

int _SMT_CP_OsCall7(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7){
	return _SMT_OsCall7(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}
EXPORT_SYMBOL(_SMT_CP_OsCall7);

int _SMT_CP_OsCall8(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8){
	return _SMT_OsCall8(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}
EXPORT_SYMBOL(_SMT_CP_OsCall8);

int _SMT_CP_OsCall9(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9){
	return _SMT_OsCall9(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
}
EXPORT_SYMBOL(_SMT_CP_OsCall9);

int _SMT_CP_OsCall10(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10){
	return _SMT_OsCall10(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
}
EXPORT_SYMBOL(_SMT_CP_OsCall10);

int _SMT_CP_OsCall11(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11){
	return _SMT_OsCall11(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
}
EXPORT_SYMBOL(_SMT_CP_OsCall11);

int _SMT_CP_OsCall12(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12){
	return _SMT_OsCall12(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
}
EXPORT_SYMBOL(_SMT_CP_OsCall12);

int _SMT_CP_OsCall13(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13){
	return _SMT_OsCall13(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
}
EXPORT_SYMBOL(_SMT_CP_OsCall13);

int _SMT_CP_OsCall14(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13,_TRQ_PRT arg14){
	return _SMT_OsCall14(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
}
EXPORT_SYMBOL(_SMT_CP_OsCall14);

int _SMT_CP_OsCall15(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13,_TRQ_PRT arg14,_TRQ_PRT arg15){
	return _SMT_OsCall15(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
}
EXPORT_SYMBOL(_SMT_CP_OsCall15);

int _SMT_CP_OsCall16(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13,_TRQ_PRT arg14,_TRQ_PRT arg15,_TRQ_PRT arg16){
	return _SMT_OsCall16(osc, (_SMT_OS_CALL)attr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
}
EXPORT_SYMBOL(_SMT_CP_OsCall16);
