/*****************************************************************************
						Copyright(c) 2010 DTS INSIGHT CORPORATION
Function: SMT standard library header file

Note:

Change history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification :NEW, CHG(Change), ADD(Addition, DEL(Delete)
 v	  v 	v
 No  Ver  Class Date	  Name			Description
---+-----+----+----------+-------------+--------------------------------------
000 03.00 NEW  2015/03/16 ---			New
*****************************************************************************/

#ifndef __SMT_CHECKPOINT_API__
#define __SMT_CHECKPOINT_API__

#ifndef __SMT_CHECKPOINT__
#include "SMTAPI.h"
typedef _SMT_UNSIGNED_32BIT_INTEGER _TRQ_PRT;
#endif // __SMT_CHECKPOINT__

 /* Debug Print */
#define	_SMT_CP_STR_MAX_SIZE_B	124
#define _SMT_CP_PUTW_BUF_SIZE_B	(_SMT_CP_STR_MAX_SIZE_B + 8)

typedef enum {
	_SMT_CP_PSZ64 = 0,
	_SMT_CP_PSZ8,
	_SMT_CP_PSZ16,
	_SMT_CP_PSZ32
} _SMT_CP_PSZ ;

typedef enum{
	_SMT_CP_PW = 0,
	_SMT_CP_PR
} _SMT_CP_PRW;

typedef enum {
	_SMT_CP_OS_ATTR_CALL = 0,
	_SMT_CP_OS_ATTR_RET
} _SMT_CP_OS_CALL ;

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus*/

	int  _SMT_CP_PortOut(_TRQ_PRT addr ,_TRQ_PRT data ,_SMT_CP_PSZ size ,_SMT_CP_PRW rw );
	int  _SMT_CP_Printf(int level, const char *format , ...);
	int  _SMT_CP_Puts(int level, const char *s);
	int  _SMT_CP_UsrMsgTag0(int level,_TRQ_PRT TagNum);
	int  _SMT_CP_UsrMsgTag1(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1);
	int  _SMT_CP_UsrMsgTag2(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1,_TRQ_PRT arg2);
	int  _SMT_CP_UsrMsgTag3(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3);
	int  _SMT_CP_UsrMsgTag4(int level,_TRQ_PRT TagNum,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4);


	int  _SMT_CP_OsSwitch_Process(_TRQ_PRT processid);
	int  _SMT_CP_OsSwitch_ThreadProcess(_TRQ_PRT threadid,_TRQ_PRT processid);
	int  _SMT_CP_OsSwitch_Process_Name(_TRQ_PRT processid,const char *str);
	int  _SMT_CP_OsSwitch_ThreadProcess_Name(_TRQ_PRT threadid,_TRQ_PRT processid,const char *tname,const char *pname);
	int  _SMT_CP_OsSwitch_Irq_in(_TRQ_PRT irqid);
	int  _SMT_CP_OsSwitch_Irq_out(_TRQ_PRT irqid);
	int  _SMT_CP_OsSwitch_Idle( void );
	int  _SMT_CP_OsCall0(int osc,_SMT_CP_OS_CALL attr);
	int  _SMT_CP_OsCall1(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1);
	int  _SMT_CP_OsCall2(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2);
	int  _SMT_CP_OsCall3(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3);
	int  _SMT_CP_OsCall4(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4);
	int  _SMT_CP_OsCall5(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5);
	int  _SMT_CP_OsCall6(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6);
	int  _SMT_CP_OsCall7(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7);
	int  _SMT_CP_OsCall8(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8);
	int  _SMT_CP_OsCall9(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9);
	int  _SMT_CP_OsCall10(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10);
	int  _SMT_CP_OsCall11(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11);
	int  _SMT_CP_OsCall12(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12);
	int  _SMT_CP_OsCall13(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13);
	int  _SMT_CP_OsCall14(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13,_TRQ_PRT arg14);
	int  _SMT_CP_OsCall15(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13,_TRQ_PRT arg14,_TRQ_PRT arg15);
	int  _SMT_CP_OsCall16(int osc,_SMT_CP_OS_CALL attr,_TRQ_PRT arg1,_TRQ_PRT arg2,_TRQ_PRT arg3,_TRQ_PRT arg4,_TRQ_PRT arg5,_TRQ_PRT arg6,_TRQ_PRT arg7,_TRQ_PRT arg8,_TRQ_PRT arg9,_TRQ_PRT arg10,_TRQ_PRT arg11,_TRQ_PRT arg12,_TRQ_PRT arg13,_TRQ_PRT arg14,_TRQ_PRT arg15,_TRQ_PRT arg16);
#ifdef __cplusplus
}
#endif /* __cplusplus*/
#endif /* __SMT_CHECKPOINT_API__*/
