#include <string.h>
#include <jni.h>
#include <stdlib.h>
#include "jp_co_dts_insight_emb_SMT.h"
#include "TRQHookc.h"
#include "SMTAPI.h"

/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    Hook0
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_dts_1insight_emb_SMT_Hook0
  (JNIEnv *env, jclass cls, jint TagNum)
{
	_TRQ_Hook0(TagNum);
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    GetDebugLevel
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_GetDebugLevel
  (JNIEnv *env, jclass cls)
{
	return _SMT_GetDebugLevel();
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    SetDebugLevel
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_dts_1insight_emb_SMT_SetDebugLevel
  (JNIEnv *env, jclass cls, jint level)
{
	_SMT_SetDebugLevel(level);
}

/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    Puts
 * Signature: (I[B)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_Puts
  (JNIEnv *env, jclass cls, jint level, jbyteArray bytes)
{
	jint ret;

	jsize len = env->GetArrayLength(bytes);
	char *s = (char*)malloc(len+1);

	jbyte *bs = env->GetByteArrayElements(bytes, NULL);
	memcpy(s, bs, len);

	env->ReleaseByteArrayElements(bytes, bs, 0);

	s[len] = '\0';

	ret = _SMT_Puts(level, s);


	free(s);

	return ret;
}

/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    UsrMsgTag0
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_UsrMsgTag0
  (JNIEnv *env, jclass cls, jint level, jint TagNum)
{
	return _SMT_UsrMsgTag0(level, TagNum);
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    UsrMsgTag1
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_UsrMsgTag1
  (JNIEnv *env, jclass cls, jint level, jint TagNum, jint arg1)
{
	return _SMT_UsrMsgTag1(level, TagNum, arg1);
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    UsrMsgTag2
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_UsrMsgTag2
  (JNIEnv *env, jclass cls, jint level, jint TagNum, jint arg1, jint arg2)
{
	return _SMT_UsrMsgTag2(level, TagNum, arg1, arg2);
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    UsrMsgTag3
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_UsrMsgTag3
  (JNIEnv *env, jclass cls, jint level, jint TagNum, jint arg1, jint arg2, jint arg3)
{
	return _SMT_UsrMsgTag3(level, TagNum, arg1, arg2, arg3);
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    UsrMsgTag4
 * Signature: (IIIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_UsrMsgTag4
  (JNIEnv *env, jclass cls, jint level, jint TagNum, jint arg1, jint arg2, jint arg3, jint arg4)
{
	return _SMT_UsrMsgTag4(level, TagNum, arg1, arg2, arg3, arg4);
}


/*
 * Class:     jp_co_dts_insight_emb_SMT
 * Method:    PortOut
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_dts_1insight_emb_SMT_PortOut
  (JNIEnv *env, jclass cls, jint addr, jint data, jint size, jint rw)
{
	return _SMT_PortOut(addr, data, (_SMT_PSZ)size, (_SMT_PRW)rw);
}
