/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01      New
 001 02.12 MOD  2014/12/12      Fixed #13672
                                #13699
 002 03.10 Mod  2016/05/20      SMTNEW-288

*****************************************************************************/
#ifndef _SMTIF_H_
#define _SMTIF_H_

/* Include specification ****************************************************/
#include <linux/ioctl.h>
#include "SMTDef.h"
#include "SMTAPI.h"
#define MODULE_NAME			"smt"
// #define DEV_SMTIF
#ifdef DEV_SMTIF
#define SMT_DEVICE			"/dev/smtif"
#else // DEV_SMTIF
#define SMT_DEVICE			"/proc/driver/smtif"
#endif // DEV_SMTIF

/* SMT Port address info IOCTL structure */
struct port_info {
	_SMT_UNSIGNED_32BIT_INTEGER mapoffset;
	_SMT_UNSIGNED_32BIT_INTEGER user;
	_SMT_UNSIGNED_32BIT_INTEGER size;
};
typedef struct port_info port_info_t;

/* SMT Port address info IOCTL structure */
struct portout_info {
	_SMT_UNSIGNED_32BIT_INTEGER addr;
	_SMT_UNSIGNED_32BIT_INTEGER data;
	_SMT_UNSIGNED_32BIT_INTEGER size;
	_SMT_UNSIGNED_32BIT_INTEGER rw;
};
typedef struct portout_info portout_info_t;

/*  _SMT_Printf info IOCTL structure */
struct printf_info {
	int 	level;
	char 	data[_SMT_STR_MAX_SIZE_B];
};
typedef struct printf_info printf_info_t;

/* _SMT_UsrMsgTag0 info IOCTL structure*/
struct usrmsgtag0_info {
	int 	level;
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
};
typedef struct usrmsgtag0_info usrmsgtag0_info_t;

/* _SMT_UsrMsgTag1 info IOCTL structure*/
struct usrmsgtag1_info {
	int 	      level;
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data;
};
typedef struct usrmsgtag1_info usrmsgtag1_info_t;

/* _SMT_UsrMsgTag2 info IOCTL structure*/
struct usrmsgtag2_info {
	int 	      level;
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[2];
};
typedef struct usrmsgtag2_info usrmsgtag2_info_t;

/* _SMT_UsrMsgTag3 info IOCTL structure*/
struct usrmsgtag3_info {
	int 	      level;
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[3];
};
typedef struct usrmsgtag3_info usrmsgtag3_info_t;

/* _SMT_UsrMsgTag4 info IOCTL structure*/
struct usrmsgtag4_info {
	int 	      level;
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[4];
};
typedef struct usrmsgtag4_info usrmsgtag4_info_t;

/* _TRQ_Hook0 info IOCTL structure*/
struct hook0_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
};
typedef struct hook0_info hook0_info_t;

/* _TRQ_Hook1 info IOCTL structure*/
struct hook1_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data;
};
typedef struct hook1_info hook1_info_t;

/* _TRQ_Hook2 info IOCTL structure*/
struct hook2_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[2];
};
typedef struct hook2_info hook2_info_t;

/* _TRQ_Hook3 info IOCTL structure*/
struct hook3_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[3];
};
typedef struct hook3_info hook3_info_t;

/* _TRQ_Hook4 info IOCTL structure*/
struct hook4_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[4];
};
typedef struct hook4_info hook4_info_t;

/* _TRQ_Hook5 info IOCTL structure*/
struct hook5_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[5];
};
typedef struct hook5_info hook5_info_t;

/* _TRQ_Hook6 info IOCTL structure*/
struct hook6_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[6];
};
typedef struct hook6_info hook6_info_t;

/* _TRQ_Hook7 info IOCTL structure*/
struct hook7_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[7];
};
typedef struct hook7_info hook7_info_t;

/* _TRQ_Hook8 info IOCTL structure*/
struct hook8_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[8];
};
typedef struct hook8_info hook8_info_t;

/* _TRQ_Hook9 info IOCTL structure*/
struct hook9_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[9];
};
typedef struct hook9_info hook9_info_t;

/* _TRQ_Hook10 info IOCTL structure*/
struct hook10_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[10];
};
typedef struct hook10_info hook10_info_t;

/* _TRQ_Hook11 info IOCTL structure*/
struct hook11_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[11];
};
typedef struct hook11_info hook11_info_t;

/* _TRQ_Hook12 info IOCTL structure*/
struct hook12_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[12];
};
typedef struct hook12_info hook12_info_t;

/* _TRQ_Hook13 info IOCTL structure*/
struct hook13_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[13];
};
typedef struct hook13_info hook13_info_t;

/* _TRQ_Hook14 info IOCTL structure*/
struct hook14_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[14];
};
typedef struct hook14_info hook14_info_t;

/* _TRQ_Hook15 info IOCTL structure*/
struct hook15_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[15];
};
typedef struct hook15_info hook15_info_t;

/* _TRQ_Hook16 info IOCTL structure*/
struct hook16_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[16];
};
typedef struct hook16_info hook16_info_t;

/* _TRQ_Hook0_sp info IOCTL structure*/
struct hook0_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook0_sp_info hook0_sp_info_t;

/* _TRQ_Hook1 info IOCTL structure*/
struct hook1_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data;
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook1_sp_info hook1_sp_info_t;

/* _TRQ_Hook2 info IOCTL structure*/
struct hook2_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[2];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook2_sp_info hook2_sp_info_t;

/* _TRQ_Hook3 info IOCTL structure*/
struct hook3_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[3];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook3_sp_info hook3_sp_info_t;

/* _TRQ_Hook4 info IOCTL structure*/
struct hook4_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[4];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook4_sp_info hook4_sp_info_t;

/* _TRQ_Hook5 info IOCTL structure*/
struct hook5_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[5];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook5_sp_info hook5_sp_info_t;

/* _TRQ_Hook6 info IOCTL structure*/
struct hook6_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[6];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook6_sp_info hook6_sp_info_t;

/* _TRQ_Hook7 info IOCTL structure*/
struct hook7_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[7];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook7_sp_info hook7_sp_info_t;

/* _TRQ_Hook8 info IOCTL structure*/
struct hook8_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[8];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook8_sp_info hook8_sp_info_t;

/* _TRQ_Hook9 info IOCTL structure*/
struct hook9_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[9];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook9_sp_info hook9_sp_info_t;

/* _TRQ_Hook10 info IOCTL structure*/
struct hook10_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[10];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook10_sp_info hook10_sp_info_t;

/* _TRQ_Hook11 info IOCTL structure*/
struct hook11_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[11];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook11_sp_info hook11_sp_info_t;

/* _TRQ_Hook12 info IOCTL structure*/
struct hook12_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[12];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook12_sp_info hook12_sp_info_t;

/* _TRQ_Hook13 info IOCTL structure*/
struct hook13_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[13];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook13_sp_info hook13_sp_info_t;

/* _TRQ_Hook14 info IOCTL structure*/
struct hook14_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[14];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook14_sp_info hook14_sp_info_t;

/* _TRQ_Hook15 info IOCTL structure*/
struct hook15_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[15];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook15_sp_info hook15_sp_info_t;

/* _TRQ_Hook16 info IOCTL structure*/
struct hook16_sp_info {
	_SMT_UNSIGNED_32BIT_INTEGER tagnum;
	_SMT_UNSIGNED_32BIT_INTEGER data[16];
	_SMT_UNSIGNED_32BIT_INTEGER sp;
};
typedef struct hook16_sp_info hook16_sp_info_t;

/* IOCTRL Command difinition*/
#define SMT_IOC_MAGIC	'q'							/* 'q'is magic number*/

#define	SMT_IOC_PORTOUT				_IO(SMT_IOC_MAGIC, 51)
#define	SMT_IOC_PUTS				_IO(SMT_IOC_MAGIC, 52)
#define	SMT_IOC_USRMSGTAG0			_IO(SMT_IOC_MAGIC, 54)
#define	SMT_IOC_USRMSGTAG1			_IO(SMT_IOC_MAGIC, 55)
#define	SMT_IOC_USRMSGTAG2			_IO(SMT_IOC_MAGIC, 56)
#define	SMT_IOC_USRMSGTAG3			_IO(SMT_IOC_MAGIC, 57)
#define	SMT_IOC_USRMSGTAG4			_IO(SMT_IOC_MAGIC, 58)
#define	SMT_IOC_HOOK0				_IO(SMT_IOC_MAGIC, 59)
#define	SMT_IOC_HOOK1				_IO(SMT_IOC_MAGIC, 60)
#define	SMT_IOC_HOOK2				_IO(SMT_IOC_MAGIC, 61)
#define	SMT_IOC_HOOK3				_IO(SMT_IOC_MAGIC, 62)
#define	SMT_IOC_HOOK4				_IO(SMT_IOC_MAGIC, 63)
#define	SMT_IOC_HOOK5				_IO(SMT_IOC_MAGIC, 64)
#define	SMT_IOC_HOOK6				_IO(SMT_IOC_MAGIC, 65)
#define	SMT_IOC_HOOK7				_IO(SMT_IOC_MAGIC, 66)
#define	SMT_IOC_HOOK8				_IO(SMT_IOC_MAGIC, 67)
#define	SMT_IOC_HOOK9				_IO(SMT_IOC_MAGIC, 68)
#define	SMT_IOC_HOOK10				_IO(SMT_IOC_MAGIC, 69)
#define	SMT_IOC_HOOK11				_IO(SMT_IOC_MAGIC, 70)
#define	SMT_IOC_HOOK12				_IO(SMT_IOC_MAGIC, 71)
#define	SMT_IOC_HOOK13				_IO(SMT_IOC_MAGIC, 72)
#define	SMT_IOC_HOOK14				_IO(SMT_IOC_MAGIC, 73)
#define	SMT_IOC_HOOK15				_IO(SMT_IOC_MAGIC, 74)
#define	SMT_IOC_HOOK16				_IO(SMT_IOC_MAGIC, 75)

#define	SMT_IOC_HOOK0_SP			_IO(SMT_IOC_MAGIC, 76)
#define	SMT_IOC_HOOK1_SP			_IO(SMT_IOC_MAGIC, 77)
#define	SMT_IOC_HOOK2_SP			_IO(SMT_IOC_MAGIC, 78)
#define	SMT_IOC_HOOK3_SP			_IO(SMT_IOC_MAGIC, 79)
#define	SMT_IOC_HOOK4_SP			_IO(SMT_IOC_MAGIC, 80)
#define	SMT_IOC_HOOK5_SP			_IO(SMT_IOC_MAGIC, 81)
#define	SMT_IOC_HOOK6_SP			_IO(SMT_IOC_MAGIC, 82)
#define	SMT_IOC_HOOK7_SP			_IO(SMT_IOC_MAGIC, 83)
#define	SMT_IOC_HOOK8_SP			_IO(SMT_IOC_MAGIC, 84)
#define	SMT_IOC_HOOK9_SP			_IO(SMT_IOC_MAGIC, 85)
#define	SMT_IOC_HOOK10_SP			_IO(SMT_IOC_MAGIC, 86)
#define	SMT_IOC_HOOK11_SP			_IO(SMT_IOC_MAGIC, 87)
#define	SMT_IOC_HOOK12_SP			_IO(SMT_IOC_MAGIC, 88)
#define	SMT_IOC_HOOK13_SP			_IO(SMT_IOC_MAGIC, 89)
#define	SMT_IOC_HOOK14_SP			_IO(SMT_IOC_MAGIC, 90)
#define	SMT_IOC_HOOK15_SP			_IO(SMT_IOC_MAGIC, 91)
#define	SMT_IOC_HOOK16_SP			_IO(SMT_IOC_MAGIC, 92)

#endif /*_SMTIF_H_*/
