/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification of New, Modify, Append, Delete
 v	  v 	v
 No  Ver  Class Date				Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01   New
 001 02.12 MOD  2014/12/12   Fixed #13672
                             #13699
 002 03.10 Mod  2016/05/20   SMTNEW-288

*****************************************************************************/

/* Include specification ****************************************************/
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include "SMTDef.h"
#include "SMTAPI.h"
#include "smtif.h"

/* External variables *******************************************************/
extern int smt_fd;

/* Internal variables *******************************************************/
#define SP_INFO 2
#define	_SMT_HOOK_DATA_SIZE_0				(1  + SP_INFO)			// Hook0 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_1				(2  + SP_INFO)			// Hook1 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_2				(4  + SP_INFO)			// Hook2 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_3				(5  + SP_INFO)			// Hook3 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_4				(6  + SP_INFO)			// Hook4 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_5				(7  + SP_INFO)			// Hook5 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_6				(8  + SP_INFO)			// Hook6 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_7				(9  + SP_INFO)			// Hook7 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_8				(10 + SP_INFO)				// Hook8 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_9				(11 + SP_INFO)				// Hook9 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_10				(12 + SP_INFO)				// Hook10 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_11				(13 + SP_INFO)				// Hook11 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_12				(14 + SP_INFO)				// Hook12 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_13				(15 + SP_INFO)				// Hook13 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_14				(16 + SP_INFO)				// Hook14 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_15				(17 + SP_INFO)				// Hook15 data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_16				(18 + SP_INFO)				// Hook16 data size(_SMT_UNSIGNED_32BIT_INTEGER)
                                                            
/*****************************************************************************
1.Function: Function IN/OUT

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number

4.Return Value:

*****************************************************************************/
void _TRQ_Hook0(_SMT_UNSIGNED_32BIT_INTEGER TagNum)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_0 ];

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = TagNum;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[1] = 1;
	out[2] = _SMT_get_SP_address();
#else
	out[1] = 0;
	out[2] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_0);



}

/*****************************************************************************
1.Function: Function IN/OUT (one argument or return value)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	arg1						argument value/return value

4.Return Value:

*****************************************************************************/
void _TRQ_Hook1(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_1 ] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = TagNum;
	out[1] = arg1;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON

	out[2] = 1;
	out[3] = _SMT_get_SP_address();
#else

	out[2] = 0;
	out[3] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_1);

}

/*****************************************************************************
1.Function: Function IN (2 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	arg1						1st argument value
I	arg2						2nd argument value

4.Return Value:

*****************************************************************************/
void _TRQ_Hook2(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_2] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_2;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[4] = 1;
	out[5] = _SMT_get_SP_address();
#else
	out[4] = 0;
	out[5] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_2);


}

/*****************************************************************************
1.Function: Function IN (3 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-3)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook3(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_3] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_3;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[5] = 1;
	out[6] = _SMT_get_SP_address();
#else
	out[5] = 0;
	out[6] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_3);


}

/*****************************************************************************
1.Function: Function IN (4 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-4)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook4(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_4] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_4;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[6] = 1;
	out[7] = _SMT_get_SP_address();
#else
	out[6] = 0;
	out[7] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_4);


}

/*****************************************************************************
1.Function: Function IN (5 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-5)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook5(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_5] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_5;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[7] = 1;
	out[8] = _SMT_get_SP_address();
#else
	out[7] = 0;
	out[8] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_5);


}

/*****************************************************************************
1.Function: Function IN (6 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-6)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook6(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_6] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_6;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[8] = 1;
	out[9] = _SMT_get_SP_address();
#else
	out[8] = 0;
	out[9] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_6);

}

/*****************************************************************************
1.Function: Function IN (7 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-7)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook7(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) 
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_7] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_7;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[9] = 1;
	out[10] = _SMT_get_SP_address();
#else
	out[9] = 0;
	out[10] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_7);

}

/*****************************************************************************
1.Function: Function IN (8 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-8)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook8(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_8] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_8;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[10] = 1;
	out[11] = _SMT_get_SP_address();
#else
	out[10] = 0;
	out[11] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_8);

}

/*****************************************************************************
1.Function: Function IN (9 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-9)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook9(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_9] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_9;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[11] = 1;
	out[12] = _SMT_get_SP_address();
#else
	out[11] = 0;
	out[12] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_9);

}

/*****************************************************************************
1.Function: Function IN (10 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-10)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook10(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_10] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_10;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[12] = 1;
	out[13] = _SMT_get_SP_address();
#else
	out[12] = 0;
	out[13] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_10);

}

/*****************************************************************************
1.Function: Function IN (11 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-11)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook11(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_11] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_11;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[13] = 1;
	out[14] = _SMT_get_SP_address();
#else
	out[13] = 0;
	out[14] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_11);

}

/*****************************************************************************
1.Function: Function IN (12 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-12)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook12(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_12] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_12;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[14] = 1;
	out[15] = _SMT_get_SP_address();
#else
	out[14] = 0;
	out[15] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_12);

}

/*****************************************************************************
1.Function: Function IN (13 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-13)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook13(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_13] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_13;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[15] = 1;
	out[16] = _SMT_get_SP_address();
#else
	out[15] = 0;
	out[16] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_13);

}

/*****************************************************************************
1.Function: Function IN (14 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-14)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook14(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_14] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_14;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[16] = 1;
	out[17] = _SMT_get_SP_address();
#else
	out[16] = 0;
	out[17] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_14);

}

/*****************************************************************************
1.Function: Function IN (15 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-15)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook15(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_15] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_15;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[17] = 1;
	out[18] = _SMT_get_SP_address();
#else
	out[17] = 0;
	out[18] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_15);

}

/*****************************************************************************
1.Function: Function IN (16 arguments)

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-16)					argument N

4.Return Value:

*****************************************************************************/
void _TRQ_Hook16(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_16] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return;
	}

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_16;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
	out[17] = arg16;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	out[18] = 1;
	out[19] = _SMT_get_SP_address();
#else
	out[18] = 0;
	out[19] = 0;
#endif
	write(smt_fd, out, _SMT_HOOK_DATA_SIZE_16);

}
