/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New   2012/10/01     New
 001 02.00 CHG  2014/01/06      Fixed #13339
 002 02.12 MOD  2014/12/12      Fixed #13672
                                #13699

*****************************************************************************/
#define __TRQUSRMSGTAG_C__

/* Include specification ****************************************************/
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include "SMTDef.h"
#include "SMTAPI.h"
#include "SMTUser.h"
#include "smtif.h"

/* External variables *******************************************************/
extern int smt_fd;

/* Internal variables *******************************************************/
#define	_SMT_USRMSGTAG_DATA_SIZE_0			1				// UsrMsgTag0 output data size(unsigned long)
#define	_SMT_USRMSGTAG_DATA_SIZE_1			2				// UsrMsgTag1 output data size(unsigned long)
#define	_SMT_USRMSGTAG_DATA_SIZE_2			3				// UsrMsgTag2 output data size(unsigned long)
#define	_SMT_USRMSGTAG_DATA_SIZE_3			4				// UsrMsgTag3 output data size(unsigned long)
#define	_SMT_USRMSGTAG_DATA_SIZE_4			5				// UsrMsgTag4 output data size(unsigned long)

/*****************************************************************************
1.Function:This function outputs the user defined message tag number as System Macro Trace
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag0( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum )
{
	int status;
	_SMT_UNSIGNED_32BIT_INTEGER out;

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return( _SMT_NG );
	}
	if ( _SMT_GetDebugLevel() & (1 <<(_SMT_UNSIGNED_32BIT_INTEGER)level) ){
		return( _SMT_OK );
	}

	out = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_0 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	status = write(smt_fd, &out, _SMT_USRMSGTAG_DATA_SIZE_0);
	if( status<0 ){
		return( _SMT_NG );
	}
	return( _SMT_OK );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number as System Macro Trace
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag1( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 )
{
	int status;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return( _SMT_NG );
	}
	if ( _SMT_GetDebugLevel() & (1 <<(_SMT_UNSIGNED_32BIT_INTEGER)level) ){
		return( _SMT_OK );
	}

	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	status = write(smt_fd, out, _SMT_USRMSGTAG_DATA_SIZE_1);
	if( status<0 ){
		return( _SMT_NG );
	}
	return( _SMT_OK );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number as System Macro Trace
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag2( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 )
{
	int status;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_2] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return( _SMT_NG );
	}
	if ( _SMT_GetDebugLevel() & (1 <<(_SMT_UNSIGNED_32BIT_INTEGER)level) ){
		return( _SMT_OK );
	}

	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_2 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;

	status = write(smt_fd, out, _SMT_USRMSGTAG_DATA_SIZE_2);
	if( status<0 ){
		return( _SMT_NG );
	}
	return( _SMT_OK );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number as System Macro Trace
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax
I/	arg3						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag3( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 )
{
	int status;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_3] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return( _SMT_NG );
	}
	if ( _SMT_GetDebugLevel() & (1 <<(_SMT_UNSIGNED_32BIT_INTEGER)level) ){
		return( _SMT_OK );
	}

	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_3 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;

	status = write(smt_fd, out, _SMT_USRMSGTAG_DATA_SIZE_3);
	if( status<0 ){
		return( _SMT_NG );
	}
	return( _SMT_OK );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number as System Macro Trace
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax
I/	arg3						Output data in accordance with the syntax
I/	arg4						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag4( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 )
{
	int status;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_4] __attribute__ ((aligned (4)));

	if( smt_fd<0 ){
		if( _SMT_Open() != _SMT_OK ) return( _SMT_NG );
	}
	if ( _SMT_GetDebugLevel() & (1 <<(_SMT_UNSIGNED_32BIT_INTEGER)level) ){
		return( _SMT_OK );
	}

	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_4 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	status = write(smt_fd, out, _SMT_USRMSGTAG_DATA_SIZE_4);
	if( status<0 ){
		return( _SMT_NG );
	}
	return( _SMT_OK );
}
