/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification of New, Modify, Append, Delete
 v	  v 	v
 No  Ver  Class Date				Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01   New
 001 02.12 MOD  2014/12/12   Fixed #13672
 002 03.10 Mod  2016/05/20   SMTNEW-288

*****************************************************************************/
#define __SMTINIT_C__

/* Include specification ****************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include "SMTAPI.h"
#include "smtif.h"

#include <string.h>

int smt_fd = -1;

int is_in_zygote() {
    char path[64];
    snprintf(path, sizeof(path), "/proc/%d/cmdline", getppid());

    FILE* f = fopen(path, "r");
    if (!f) return 0;

    char cmdline[256];
    fgets(cmdline, sizeof(cmdline), f);
    fclose(f);

    return strstr(cmdline, "zygote") != NULL;
}

/*****************************************************************************
1.Function: output Stack pointer address

2.Restriction, Cautions:
	not support 64bit address

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:

*****************************************************************************/
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
_SMT_UNSIGNED_32BIT_INTEGER _SMT_get_SP_address(){
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr = 0 ;

	<<< Caution >>> Please delete this line, and code the program.
//	#ifdef __GNUC__
//  sp_addr = __builtin_frame_address(0);
//	#endif

	return sp_addr;
}

#endif

/*****************************************************************************
1.Function: SMT interface initialization

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Init( void )
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: SMT library initialization

2.Restriction, Cautions: After initialization of the user application, it is necessary to call this function once.

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Open( void )
{
	if(smt_fd>=0){
		return( _SMT_NG );
	}
#if 0
	smt_fd = open(SMT_DEVICE,O_RDWR);
#else
	smt_fd = open(SMT_DEVICE,O_RDWR);
#endif
	if (smt_fd < 0) {
		return( _SMT_NG );
	}
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: SMT library close

2.Restriction, Cautions:Normally do not use this.
	It can be only used just before an application, which transforms into a new process by exec system call, calls up exec.
	This is a function to prevent a new application after exec cannot close a file descriptor.
	Take into consideration of multi-thread, it does not reset munmap and file descriptor daringly. By doing so, it safely outputs information into TRQer port from other threads after calling up this function till executing exec.

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Close( void )
{
	if( smt_fd<0 ){
		return( _SMT_OK );
	}
	close(smt_fd);
	return( _SMT_OK );
}
