package jp.co.dts_insight.emb;
import java.io.UnsupportedEncodingException;
import java.lang.String;

/**
 * System Macro Trace API library for Java
 * 
 * @version 	0.00, 12 Sep, 2011
 * @author DTS INSIGHT CORPORATION
 */
public class SMT {
	static {
		System.loadLibrary("smtjni.dist");
	}

	/**
	 * <font color=red><B>Please never use this function.</B></font>
	 * <font color=red><B>It is inserted by CheckPointTools.</B></font>
	 * This function outputs a checkpoint number as System Macro Trace information.
	 * @param TagNum checkpoint number
	 */
	public native static void Hook0(int TagNum);

	/**
	 * This function returns a current value of debug print output level mask.
	 * @return Current setting value of debug print output level mask.
	 */
	public native static int GetDebugLevel();

	/**
	 * This function sets debug print output level mask.
	 * @param level Setting value of debug print output level mask.
	 */
	public native static void SetDebugLevel(int level);

	/**
	 * This function outputs the user defined message tag number as System Macro Trace information.
	 * @param level Level of debug statement output
	 * @param TagNum Message tag number 0 to 1023
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */	
	public native static int UsrMsgTag0(int level, int TagNum);

	/**
	 * This function outputs the user defined message tag number and one data as System Macro Trace information.
	 * @param level Level of debug statement output
	 * @param TagNum Message tag number 0 to 1023
	 * @param arg1 Output data in accordance with the syntax
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	public native static int UsrMsgTag1(int level, int TagNum, int arg1);

	/**
	 * This function outputs the user defined message tag number and one data as System Macro Trace information.
	 * @param level Level of debug statement output
	 * @param TagNum Message tag number 0 to 1023
	 * @param arg1 Output data in accordance with the syntax
	 * @param arg2 Output data in accordance with the syntax
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	public native static int UsrMsgTag2(int level, int TagNum, int arg1, int arg2);

	/**
	 * This function outputs the user defined message tag number and one data as System Macro Trace information.
	 * @param level Level of debug statement output
	 * @param TagNum Message tag number 0 to 1023
	 * @param arg1 Output data in accordance with the syntax
	 * @param arg2 Output data in accordance with the syntax
	 * @param arg3 Output data in accordance with the syntax
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	public native static int UsrMsgTag3(int level, int TagNum, int arg1, int arg2, int arg3);

	/**
	 * This function outputs the user defined message tag number and one data as System Macro Trace information.
	 * @param level Level of debug statement output
	 * @param TagNum Message tag number 0 to 1023
	 * @param arg1 Output data in accordance with the syntax
	 * @param arg2 Output data in accordance with the syntax
	 * @param arg3 Output data in accordance with the syntax
	 * @param arg4 Output data in accordance with the syntax
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	public native static int UsrMsgTag4(int level, int TagNum, int arg1, int arg2, int arg3, int arg4);

	/**
	 * This function outputs character strings onto a trace.
	 * @param level Level of debug print output.
	 * @param s string to output.
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	native static int Puts(int level, byte s[]);

	/**
	 * This function outputs strings onto a trace.
	 * @param level Level of debug print output
	 * @param str string to output
	 * @param enc encoding.
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 * @throws UnsupportedEncodingException If the named encoding is not supported
	 */
	public static int Puts(int level, String str, String enc ) throws UnsupportedEncodingException {
		byte [] bytes = str.getBytes(enc);
		return Puts(level, bytes);
	}

	/**
	 * This function outputs strings(UTF-8) onto a trace.
	 * @param level Level of debug print output
	 * @param s string to output
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 * @throws UnsupportedEncodingException If the named encoding is not supported
	 */
	public static int Puts(int level, String s) throws UnsupportedEncodingException {
		return Puts(level, s, "UTF-8");
	}

	/**
	 * This function outputs port access information.
	 * @param addr Address
	 * @param data Data
	 * @param size Port size
	 * @param rw Access type
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	native static int PortOut(int addr, int data, int size, int rw);

	/**
	 * Port size 
	 *
	 */
	public enum PSZ {
		/**
		 * 8bit
		 */
		PSZ8(1),
		/**
		 * 16bit
		 */
		PSZ16(2),
		/**
		 * 32bit
		 */
		PSZ32(3);

		private int value;

		private PSZ(int value) {
			this.value = value;
		}
		private int getValue() {
			return this.value;
		}
	};

	/**
	 * Access type
	 *
	 */
	public enum PRW {
		/**
		 * Write
		 */
		PW(0),
		/**
		 * Read
		 */
		PR(1);
		private int value;

		private PRW(int value) {
			this.value = value;
		}
		private int getValue() {
			return this.value;
		}

	};
	/**
	 * This function outputs port access information.
	 * @param addr Address
	 * @param data Data
	 * @param size Port size
	 * @param rw Access type
	 * @return Returns execution results. Returns 0 (End normally) or -1 (End abnormally).
	 */
	public static int PortOut(int addr, int data, PSZ size, PRW rw) {
		return PortOut(addr, data, size.getValue(), rw.getValue() );
	}	 
}
