/****************************************************************************
                        Copyright(c) 2012 DTS INSIGHT CORPORATION
 Function: System Macro Trace Device Driver : Stand Alone Model

 Note: Proto Type.

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date      Name          Description
 ---+-----+----+----------+-------------+-------------------------------------
 000 00.00 New  2012/11/01 YDC          New document
 001 02.12 Mod  2015/02/16              #13699
 002 03.00 MOD  2015/05/12              Supported #13749
 003 03.10 Mod  2016/05/20              SMTNEW-288
*****************************************************************************/

/* Include specification ****************************************************/
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <asm/io.h>

#include <smt/SMTAPI.h>
#include <smt/SMTAPI_CP.h>

#include "SMTDef.h"

/* Function prototypes ******************************************************/
int  SMT_Putw(int level,const char *s);


/* Static Function prototypes ***********************************************/
static _SMT_UNSIGNED_32BIT_INTEGER smt_strlen(const char *s);
static void os_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER *out);
void os_len_putw(const char *name,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER olen,_SMT_UNSIGNED_32BIT_INTEGER *out);
_SMT_UNSIGNED_32BIT_INTEGER os_strlen(const char *s);


static int _SMT_PortOut_core(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw);
static int _SMT_Printf_core(int level,const char *format , ...);
static int _SMT_Puts_core(int level,const char *s);
static int _SMT_UsrMsgTag0_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum);
static int _SMT_UsrMsgTag1_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
static int _SMT_UsrMsgTag2_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
static int _SMT_UsrMsgTag3_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
static int _SMT_UsrMsgTag4_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
static int _SMT_OsSwitch_Process_core(_SMT_UNSIGNED_32BIT_INTEGER processid);
static int _SMT_OsSwitch_ThreadProcess_core(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid);
static int _SMT_OsSwitch_Process_Name_core(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str);
static int _SMT_OsSwitch_ThreadProcess_Name_core(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname);
static int _SMT_OsSwitch_Irq_in_core(_SMT_UNSIGNED_32BIT_INTEGER irqid);
static int _SMT_OsSwitch_Irq_out_core(_SMT_UNSIGNED_32BIT_INTEGER irqid);
static int _SMT_OsSwitch_Idle_core( void );

static int _SMT_OsCall0_core(int osc,_SMT_OS_CALL attr);
static int _SMT_OsCall1_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1);
static int _SMT_OsCall2_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
static int _SMT_OsCall3_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
static int _SMT_OsCall4_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
static int _SMT_OsCall5_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5);
static int _SMT_OsCall6_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6);
static int _SMT_OsCall7_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7);
static int _SMT_OsCall8_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8);
static int _SMT_OsCall9_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9);
static int _SMT_OsCall10_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10);
static int _SMT_OsCall11_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11);
static int _SMT_OsCall12_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12);
static int _SMT_OsCall13_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13);
static int _SMT_OsCall14_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14);
static int _SMT_OsCall15_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15);
static int _SMT_OsCall16_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16);

static void _SMT_Hook0_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum);
static void _SMT_Hook1_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
static void _SMT_Hook2_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
static void _SMT_Hook3_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
static void _SMT_Hook4_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
static void _SMT_Hook5_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5);
static void _SMT_Hook6_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6);
static void _SMT_Hook7_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7);
static void _SMT_Hook8_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8);
static void _SMT_Hook9_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9);
static void _SMT_Hook10_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10);
static void _SMT_Hook11_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11);
static void _SMT_Hook12_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12);
static void _SMT_Hook13_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13);
static void _SMT_Hook14_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14);
static void _SMT_Hook15_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15);
static void _SMT_Hook16_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16);

/* Internal variables *******************************************************/
static int SMTDebugLevel 		  = SMT_LV_MSK;

int (*_SMT_PortOut)(_SMT_UNSIGNED_32BIT_INTEGER addr ,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw)												= _SMT_PortOut_core;
int (*_SMT_Printf)(int level,const char *format , ...)																				= _SMT_Printf_core;
int (*_SMT_Puts)(int level,const char *s)																							= _SMT_Puts_core;
int (*_SMT_UsrMsgTag0)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum)																				= _SMT_UsrMsgTag0_core;
int (*_SMT_UsrMsgTag1)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)															= _SMT_UsrMsgTag1_core;
int (*_SMT_UsrMsgTag2)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)										= _SMT_UsrMsgTag2_core;
int (*_SMT_UsrMsgTag3)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)						= _SMT_UsrMsgTag3_core;
int (*_SMT_UsrMsgTag4)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)	= _SMT_UsrMsgTag4_core;
int (*_SMT_OsSwitch_Process)(_SMT_UNSIGNED_32BIT_INTEGER processid) 																				= _SMT_OsSwitch_Process_core;
int (*_SMT_OsSwitch_ThreadProcess)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid) 													= _SMT_OsSwitch_ThreadProcess_core;
int (*_SMT_OsSwitch_Process_Name)(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str) 															= _SMT_OsSwitch_Process_Name_core;
int (*_SMT_OsSwitch_ThreadProcess_Name)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname) 		= _SMT_OsSwitch_ThreadProcess_Name_core;
int (*_SMT_OsSwitch_Irq_in)(_SMT_UNSIGNED_32BIT_INTEGER irqid) 																					= _SMT_OsSwitch_Irq_in_core;
int (*_SMT_OsSwitch_Irq_out)(_SMT_UNSIGNED_32BIT_INTEGER irqid) 																					= _SMT_OsSwitch_Irq_out_core;
int (*_SMT_OsSwitch_Idle)( void ) 																									= _SMT_OsSwitch_Idle_core;

int (*_SMT_OsCall0)(int osc,_SMT_OS_CALL attr) 																						= _SMT_OsCall0_core;
int (*_SMT_OsCall1)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1) 																	= _SMT_OsCall1_core;
int (*_SMT_OsCall2)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) 												= _SMT_OsCall2_core;
int (*_SMT_OsCall3)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) 							= _SMT_OsCall3_core;
int (*_SMT_OsCall4)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) 			= _SMT_OsCall4_core;
int (*_SMT_OsCall5)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) 																																																							= _SMT_OsCall5_core;
int (*_SMT_OsCall6)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) 																																																		= _SMT_OsCall6_core;
int (*_SMT_OsCall7)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) 																																													= _SMT_OsCall7_core;
int (*_SMT_OsCall8)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) 																																								= _SMT_OsCall8_core;
int (*_SMT_OsCall9)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)																																				= _SMT_OsCall9_core;
int (*_SMT_OsCall10)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) 																														= _SMT_OsCall10_core;
int (*_SMT_OsCall11)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) 																									= _SMT_OsCall11_core;
int (*_SMT_OsCall12)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) 																				= _SMT_OsCall12_core;
int (*_SMT_OsCall13)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) 															= _SMT_OsCall13_core;
int (*_SMT_OsCall14)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) 										= _SMT_OsCall14_core;
int (*_SMT_OsCall15)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) 					= _SMT_OsCall15_core;
int (*_SMT_OsCall16)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) = _SMT_OsCall16_core;

void (*_TRQ_Hook0)(_SMT_UNSIGNED_32BIT_INTEGER TagNum)																							= _SMT_Hook0_core;
void (*_TRQ_Hook1)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)																			= _SMT_Hook1_core;
void (*_TRQ_Hook2)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)														= _SMT_Hook2_core;
void (*_TRQ_Hook3)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)									= _SMT_Hook3_core;
void (*_TRQ_Hook4)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)				= _SMT_Hook4_core;
void (*_TRQ_Hook5)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)																																																								= _SMT_Hook5_core;
void (*_TRQ_Hook6)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) 																																																			= _SMT_Hook6_core;
void (*_TRQ_Hook7)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7)																																														= _SMT_Hook7_core;
void (*_TRQ_Hook8)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) 																																									= _SMT_Hook8_core;
void (*_TRQ_Hook9)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)																																					= _SMT_Hook9_core;
void (*_TRQ_Hook10)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10)																															= _SMT_Hook10_core;
void (*_TRQ_Hook11)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11)																										= _SMT_Hook11_core;
void (*_TRQ_Hook12)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12)																					= _SMT_Hook12_core;
void (*_TRQ_Hook13)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13)																= _SMT_Hook13_core;
void (*_TRQ_Hook14)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14)											= _SMT_Hook14_core;
void (*_TRQ_Hook15)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15)						= _SMT_Hook15_core;
void (*_TRQ_Hook16)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16)	= _SMT_Hook16_core;


EXPORT_SYMBOL(_SMT_PortOut);
EXPORT_SYMBOL(_SMT_Printf);
EXPORT_SYMBOL(_SMT_Puts);
EXPORT_SYMBOL(_SMT_UsrMsgTag0);
EXPORT_SYMBOL(_SMT_UsrMsgTag1);
EXPORT_SYMBOL(_SMT_UsrMsgTag2);
EXPORT_SYMBOL(_SMT_UsrMsgTag3);
EXPORT_SYMBOL(_SMT_UsrMsgTag4);
EXPORT_SYMBOL(_SMT_OsSwitch_Process);
EXPORT_SYMBOL(_SMT_OsSwitch_ThreadProcess);
EXPORT_SYMBOL(_SMT_OsSwitch_Process_Name);
EXPORT_SYMBOL(_SMT_OsSwitch_ThreadProcess_Name);
EXPORT_SYMBOL(_SMT_OsSwitch_Irq_in);
EXPORT_SYMBOL(_SMT_OsSwitch_Irq_out);
EXPORT_SYMBOL(_SMT_OsSwitch_Idle);
EXPORT_SYMBOL(_SMT_OsCall0);
EXPORT_SYMBOL(_SMT_OsCall1);
EXPORT_SYMBOL(_SMT_OsCall2);
EXPORT_SYMBOL(_SMT_OsCall3);
EXPORT_SYMBOL(_SMT_OsCall4);
EXPORT_SYMBOL(_SMT_OsCall5);
EXPORT_SYMBOL(_SMT_OsCall6);
EXPORT_SYMBOL(_SMT_OsCall7);
EXPORT_SYMBOL(_SMT_OsCall8);
EXPORT_SYMBOL(_SMT_OsCall9);
EXPORT_SYMBOL(_SMT_OsCall10);
EXPORT_SYMBOL(_SMT_OsCall11);
EXPORT_SYMBOL(_SMT_OsCall12);
EXPORT_SYMBOL(_SMT_OsCall13);
EXPORT_SYMBOL(_SMT_OsCall14);
EXPORT_SYMBOL(_SMT_OsCall15);
EXPORT_SYMBOL(_SMT_OsCall16);
EXPORT_SYMBOL(_TRQ_Hook0);
EXPORT_SYMBOL(_TRQ_Hook1);
EXPORT_SYMBOL(_TRQ_Hook2);
EXPORT_SYMBOL(_TRQ_Hook3);
EXPORT_SYMBOL(_TRQ_Hook4);
EXPORT_SYMBOL(_TRQ_Hook5);
EXPORT_SYMBOL(_TRQ_Hook6);
EXPORT_SYMBOL(_TRQ_Hook7);
EXPORT_SYMBOL(_TRQ_Hook8);
EXPORT_SYMBOL(_TRQ_Hook9);
EXPORT_SYMBOL(_TRQ_Hook10);
EXPORT_SYMBOL(_TRQ_Hook11);
EXPORT_SYMBOL(_TRQ_Hook12);
EXPORT_SYMBOL(_TRQ_Hook13);
EXPORT_SYMBOL(_TRQ_Hook14);
EXPORT_SYMBOL(_TRQ_Hook15);
EXPORT_SYMBOL(_TRQ_Hook16);



/*****************************************************************************
Function: Output Address,Data,Size,Read/Write info.
*****************************************************************************/
int _SMT_PortOut_core(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_PORTOUT_DATA_SIZE] __attribute__ ((aligned(4)));

	out[0] = _SMT_ATR_PORTOUT | _SMT_OUT_SIZE_PORTOUT | ((rw & _SMT_MASK_PORTOUT_RW) << _SMT_PORTOUT_RW_POS) | (size & _SMT_MASK_PORTOUT_SIZE);
	out[1] = addr;
	out[2] = data;
	return( _SMT_Output(_SMT_PORTOUT_DATA_SIZE,out) );
}

/*****************************************************************************
Function: Output string. Equivalent to printf function
*****************************************************************************/
int _SMT_Printf_core(int level,const char *format , ...)
{
	va_list	ap;
	char s[_SMT_STR_MAX_SIZE_B] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	va_start(ap,format);
	vsnprintf(s,_SMT_STR_MAX_SIZE_B,format,ap);
	va_end(ap);
	return( SMT_Putw(level,s) );
}

/*****************************************************************************
Function: Output string. 
*****************************************************************************/
int _SMT_Puts_core(int level,const char *s)
{
	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	return( SMT_Putw(level,s) );
}

/*****************************************************************************
Function: Output _SMT_UsrMsgTag0
*****************************************************************************/
int _SMT_UsrMsgTag0_core( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum )
{
	_SMT_UNSIGNED_32BIT_INTEGER out;

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_0 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_0,&out) );
}

/*****************************************************************************
Function: Output _SMT_UsrMsgTag1
*****************************************************************************/
int _SMT_UsrMsgTag1_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_1,out) );
}

/*****************************************************************************
Function: Output _SMT_UsrMsgTag2
*****************************************************************************/
int _SMT_UsrMsgTag2_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_2] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_2 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_2,out) );
}

/*****************************************************************************
Function: Output _SMT_UsrMsgTag3
*****************************************************************************/
int _SMT_UsrMsgTag3_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_3] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_3 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_3,out) );
}

/*****************************************************************************
Function: Output _SMT_UsrMsgTag4
*****************************************************************************/
int _SMT_UsrMsgTag4_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_4] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_4 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_4,out) );
}

/*****************************************************************************
Function: Output string. (1WORD=4Byte)
*****************************************************************************/
int SMT_Putw(int level,const char *s)
{
	_SMT_UNSIGNED_32BIT_INTEGER data;
	int i;
	_SMT_UNSIGNED_32BIT_INTEGER len;
	_SMT_UNSIGNED_32BIT_INTEGER size_word = 0;
	_SMT_UNSIGNED_32BIT_INTEGER pos = 0;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_PRINTF_BUF_SIZE_B/sizeof(_SMT_UNSIGNED_32BIT_INTEGER)] __attribute__ ((aligned (4)));;

	len = smt_strlen((char *)s);
	size_word = (len + sizeof(_SMT_UNSIGNED_32BIT_INTEGER)) / (sizeof(_SMT_UNSIGNED_32BIT_INTEGER));
	size_word = ((len % 4) == 0) ? size_word - 1 : size_word;
	out[pos]  = _SMT_ATR_PRINT | ((size_word) << _SMT_OUT_SIZE_POS) | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS);
	pos++;

	for(i=0;i<size_word;i++){
		data = 0x00000000UL;
		switch (len - (i * 4)) {
		case 1:
			data  = *s++;
			break ;
		case 2:
			data  = *s++;
			data += *s++ << 8;
			break ;
		case 3:
			data  = *s++;
			data += *s++ << 8;
			data += *s++ << 16;
			break ;
		default:
			data  = *s++;
			data += *s++ << 8;
			data += *s++ << 16;
			data += *s++ << 24;
			break ;
		}
		out[pos] = data;
		pos++;
	}

	return( _SMT_Output(pos,out) );
}

/*****************************************************************************
Function: Count String length.  Max 124byte
*****************************************************************************/
static _SMT_UNSIGNED_32BIT_INTEGER smt_strlen(const char *s)
{
	_SMT_UNSIGNED_32BIT_INTEGER i=0;

	while (s[i] != '\0') {
		i++;
		if( i >= _SMT_STR_MAX_SIZE_B ){
			break;
		}
	}
	if( i>_SMT_STR_MAX_SIZE_B ){
		i = _SMT_STR_MAX_SIZE_B;
	}
	return(i);
}

/*****************************************************************************
Function: OS switching (Process ID)
*****************************************************************************/
int _SMT_OsSwitch_Process_core(_SMT_UNSIGNED_32BIT_INTEGER processid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_PROCESS] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_PROCESS | _SMT_OS_SWITCH_PROCESS;
	out[1] = processid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_PROCESS,out) );
}

/*****************************************************************************
Function: OS switching (Thread ID & Prosess ID)
*****************************************************************************/
int _SMT_OsSwitch_ThreadProcess_core(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_THREAD] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_THREAD | _SMT_OS_SWITCH_THREAD;
	out[1] = threadid;
	out[2] = processid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_THREAD,out) );
}

/*****************************************************************************
Function: OS switching (Prosess ID & Prosess Name)
*****************************************************************************/
int _SMT_OsSwitch_Process_Name_core(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str)
{
	_SMT_UNSIGNED_32BIT_INTEGER len,full;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_PROCESS + (_SMT_OS_SWITCH_NAME_MAX/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))]  __attribute__ ((aligned (4)));

	len  = os_strlen( str );
	full = _SMT_OS_SWITCH_DATA_SIZE_PROCESS + ((len + sizeof(_SMT_UNSIGNED_32BIT_INTEGER)) / sizeof(_SMT_UNSIGNED_32BIT_INTEGER));
	out[0] = _SMT_ATR_OS_SWITCH | ((full-1) << _SMT_OUT_SIZE_POS) | _SMT_OS_SWITCH_PROCESS_NAME;
	out[1] = processid;
	os_putw((const char*)str,len,&out[2]);
	return( _SMT_Output(full,out) );
}

/*****************************************************************************
Function: OS switching (Thread/Prosess ID & Thread/Prosess Name)
*****************************************************************************/
int _SMT_OsSwitch_ThreadProcess_Name_core(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname)
{
	_SMT_UNSIGNED_32BIT_INTEGER tlen,plen,olen,full;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_THREAD + ((_SMT_OS_SWITCH_NAME_MAX/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))*2)] __attribute__ ((aligned (4)));

	tlen  = os_strlen( tname );
	plen  = os_strlen( pname );
	if( tlen<plen ){
		olen = plen;
	}
	else{
		olen = tlen;
	}
	full = _SMT_OS_SWITCH_DATA_SIZE_THREAD + (((olen + sizeof(_SMT_UNSIGNED_32BIT_INTEGER)) / sizeof(_SMT_UNSIGNED_32BIT_INTEGER))*2);
	out[0] = _SMT_ATR_OS_SWITCH | ((full-1) << _SMT_OUT_SIZE_POS) | _SMT_OS_SWITCH_THREAD_NAME;
	out[1] = threadid;
	out[2] = processid;
	os_len_putw(tname,tlen,olen,&out[3]);
	os_len_putw(pname,plen,olen,&out[3+((olen+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))]);
	return( _SMT_Output(full,out) );
}

/*****************************************************************************
Function: OS switching (Irq in)
*****************************************************************************/
int _SMT_OsSwitch_Irq_in_core(_SMT_UNSIGNED_32BIT_INTEGER irqid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_IRQ_IN] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_IRQ_IN | _SMT_OS_SWITCH_IRQ_IN;
	out[1] = irqid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_IRQ_IN,out) );
}

/*****************************************************************************
Function: OS switching (Irq out)
*****************************************************************************/
int _SMT_OsSwitch_Irq_out_core(_SMT_UNSIGNED_32BIT_INTEGER irqid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_IRQ_OUT] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_IRQ_IN | _SMT_OS_SWITCH_IRQ_OUT;
	out[1] = irqid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_IRQ_OUT,out) );
}

/*****************************************************************************
Function: OS switching (Idle)
*****************************************************************************/
int _SMT_OsSwitch_Idle_core( void )
{
	_SMT_UNSIGNED_32BIT_INTEGER out;

	out = _SMT_ATR_OS_SWITCH |  _SMT_OS_SWITCH_IDLE;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_IDLE,&out) );
}

/*****************************************************************************
Function: Output string
*****************************************************************************/
static void os_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER *out)
{
	_SMT_UNSIGNED_32BIT_INTEGER data;
	int acc,i;
	acc  = len / sizeof(_SMT_UNSIGNED_32BIT_INTEGER);
	for(i=0;i<acc;i++){
		data = *str++ ;
		data |= *str++ << 8;
		data |= *str++ << 16;
		data |= *str++ << 24;
		*out = data;
		out++;
	}
	switch( len-acc*sizeof(_SMT_UNSIGNED_32BIT_INTEGER) ){
	case 0:
		data			= 0x00000000UL;
		*out = data;
		break;
	case 1:
		data         	= 0x00000000UL;
		data = *str++ ;		
		*out = data;
		break;
	case 2:
		data         	= 0x00000000UL;
		data = *str++ ;
		data |= *str++ << 8;
		*out = data;
		break;
	case 3:
		data         	= 0x00000000UL;
		data = *str++ ;
		data |= *str++ << 8;
		data |= *str++ << 16;
		*out = data;
		break;
	}
}

/*****************************************************************************
Function: Output string (null padding)
*****************************************************************************/
//static void os_len_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER olen,_SMT_UNSIGNED_32BIT_INTEGER *out)
void os_len_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER olen,_SMT_UNSIGNED_32BIT_INTEGER *out)
{
	_SMT_UNSIGNED_32BIT_INTEGER i,less,next;

	os_putw(str,len,out);

	less = ((olen+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))-((len+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER));
	next = (len+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER);
	for(i=0;i<less;i++){
		out[next] = 0x0UL;
	}
}

/*****************************************************************************
Function: Count number of characters
*****************************************************************************/
//static _SMT_UNSIGNED_32BIT_INTEGER os_strlen(const char *s)
_SMT_UNSIGNED_32BIT_INTEGER os_strlen(const char *s)
{
	_SMT_UNSIGNED_32BIT_INTEGER i;

	i=0;
	while( s[i]!='\0' ){
		i++;
		if( _SMT_OS_SWITCH_NAME_MAX<=i ){
			break;
		}
	}
	return( i );
}

/*****************************************************************************
Function: OS system call (no argument)
*****************************************************************************/
int _SMT_OsCall0_core(int osc,_SMT_OS_CALL attr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out;

	out = _SMT_ATR_OS_CALL | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_0,&out) );
}

/*****************************************************************************
Function: OS system call (one argument)
*****************************************************************************/
int _SMT_OsCall1_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_1] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_1 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_1,out) );
}

/*****************************************************************************
Function: OS system call (2 arguments)
*****************************************************************************/
int _SMT_OsCall2_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_2] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_2 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_2,out) );
}

/*****************************************************************************
Function: OS system call (3 arguments)
*****************************************************************************/
int _SMT_OsCall3_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_3] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_3 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_3,out) );
}

/*****************************************************************************
Function: OS system call (4 arguments)
*****************************************************************************/
int _SMT_OsCall4_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_4] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_4 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_4,out) );
}

/*****************************************************************************
Function: OS system call (5 arguments)
*****************************************************************************/
int _SMT_OsCall5_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_5] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_5 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_5,out) );
}

/*****************************************************************************
Function: OS system call (6 arguments)
*****************************************************************************/
int _SMT_OsCall6_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_6] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_6 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_6,out) );
}

/*****************************************************************************
Function: OS system call (7 arguments)
*****************************************************************************/
int _SMT_OsCall7_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_7] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_7 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_7,out) );
}

/*****************************************************************************
Function: OS system call (8 arguments)
*****************************************************************************/
int _SMT_OsCall8_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_8] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_8 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_8,out) );
}

/*****************************************************************************
Function: OS system call (9 arguments)
*****************************************************************************/
int _SMT_OsCall9_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_9] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_9 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_9,out) );
}

/*****************************************************************************
Function: OS system call (10 arguments)
*****************************************************************************/
int _SMT_OsCall10_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_10] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_10 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_10,out) );
}

/*****************************************************************************
Function: OS system call (11 arguments)
*****************************************************************************/
int _SMT_OsCall11_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_11] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_11 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_11,out) );
}

/*****************************************************************************
Function: OS system call (12 arguments)
*****************************************************************************/
int _SMT_OsCall12_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_12] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_12 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_12,out) );
}

/*****************************************************************************
Function: OS system call (13 arguments)
*****************************************************************************/
int _SMT_OsCall13_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_13] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_13 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_13,out) );
}

/*****************************************************************************
Function: OS system call (14 arguments)
*****************************************************************************/
int _SMT_OsCall14_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_14] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_14 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	out[14]= arg14;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_14,out) );
}

/*****************************************************************************
Function: OS system call (15 arguments)
*****************************************************************************/
int _SMT_OsCall15_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_15] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_15 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	out[14]= arg14;
	out[15]= arg15;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_15,out) );
}

/*****************************************************************************
Function: OS system call (16 arguments)
*****************************************************************************/
int _SMT_OsCall16_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_16] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_16 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	out[14]= arg14;
	out[15]= arg15;
	out[16]= arg16;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_16,out) );
}

/*****************************************************************************
Function: Function in/out (no argument, no return value)
*****************************************************************************/
void _SMT_Hook0_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum)
{

	_SMT_UNSIGNED_32BIT_INTEGER out;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif 

	out = TagNum;
	
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_0,&out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_0,&out);
#endif
}

/*****************************************************************************
Function: Function in/out (one argument and return value)
*****************************************************************************/
void _SMT_Hook1_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_1] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = TagNum;
	out[1] = arg1;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_1,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_1,out);
#endif
}

/*****************************************************************************
Function: Function in/out (2 arguments)
*****************************************************************************/
void _SMT_Hook2_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_2] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_2;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;


#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_2,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_2,out);
#endif

}

/*****************************************************************************
Function: Function in/out (3 arguments)
*****************************************************************************/
void _SMT_Hook3_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_3] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_3;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_3,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_3,out);
#endif
}

/*****************************************************************************
Function: Function in/out (4 arguments)
*****************************************************************************/
void _SMT_Hook4_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_4] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_4;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_4,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_4,out);
#endif
}

/*****************************************************************************
Function: Function in/out (5 arguments)
*****************************************************************************/
void _SMT_Hook5_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_5] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_5;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_5,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_5,out);
#endif
}

/*****************************************************************************
Function: Function in/out (6 arguments)
*****************************************************************************/
void _SMT_Hook6_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_6] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_6;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_6,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_6,out);
#endif
}

/*****************************************************************************
Function: Function in/out (7 arguments)
*****************************************************************************/
void _SMT_Hook7_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_7] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_7;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_7,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_7,out);
#endif
}

/*****************************************************************************
Function: Function in/out (8 arguments)
*****************************************************************************/
void _SMT_Hook8_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_8] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_8;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_8,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_8,out);
#endif
}

/*****************************************************************************
Function: Function in/out (9 arguments)
*****************************************************************************/
void _SMT_Hook9_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_9] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_9;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_9,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_9,out);
#endif
}

/*****************************************************************************
Function: Function in/out (10 arguments)
*****************************************************************************/
void _SMT_Hook10_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_10] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_10;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_10,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_10,out);
#endif

}

/*****************************************************************************
Function: Function in/out (11 arguments)
*****************************************************************************/
void _SMT_Hook11_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_11] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_11;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_11,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_11,out);
#endif

}

/*****************************************************************************
Function: Function in/out (12 arguments)
*****************************************************************************/
void _SMT_Hook12_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_12] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_12;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_12,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_12,out);
#endif
}

/*****************************************************************************
Function: Function in/out (13 arguments)
*****************************************************************************/
void _SMT_Hook13_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_13] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_13;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_13,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_13,out);
#endif
}

/*****************************************************************************
Function: Function in/out (14 arguments)
*****************************************************************************/
void _SMT_Hook14_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_14] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_14;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_14,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_14,out);
#endif
}

/*****************************************************************************
Function: Function in/out (15 arguments)
*****************************************************************************/
void _SMT_Hook15_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_15] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_15;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_15,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_15,out);
#endif
}

/*****************************************************************************
Function: Function in/out (16 arguments)
*****************************************************************************/
void _SMT_Hook16_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_16] __attribute__ ((aligned (4)));
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr;
#endif

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_16;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
	out[17] = arg16;

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	sp_addr = 	_SMT_get_SP_address();	
	_SMT_Output_SP(_SMT_HOOK_DATA_SIZE_16,out,_SMT_SP_OUTPUT_ENABLE,sp_addr);
#else
	_SMT_Output(_SMT_HOOK_DATA_SIZE_16,out);
#endif
}


/*****************************************************************************
Function: Get DebugLevel
*****************************************************************************/
int	_SMT_GetDebugLevel( void )
{
	return SMTDebugLevel;
}
EXPORT_SYMBOL(_SMT_GetDebugLevel);

/*****************************************************************************
Function: Set DebugLevel
*****************************************************************************/
void _SMT_SetDebugLevel( int level )
{
	SMTDebugLevel = level;
}
EXPORT_SYMBOL(_SMT_SetDebugLevel);


/*****************************************************************************
1.Function: Library uninitialized when for _SMT_CP_Printf() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-16)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int  _SMT_CP_Printf(int level, const char *format , ...){

	va_list	ap;
	char s[_SMT_CP_PUTW_BUF_SIZE_B] __attribute__ ((aligned (4)));
	va_start(ap,format);
	vsnprintf(s,_SMT_CP_PUTW_BUF_SIZE_B,format,ap);
	va_end(ap);
	return( _SMT_Puts(level,s) );
}
EXPORT_SYMBOL(_SMT_CP_Printf);